 /*********************************                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           /*********************************
**   DBEditor Ver 1.0.0         **
**   Programmed by Ryan Best    **
**   Copyright 1992, Ryan Best **
**********************************
*
******** VAR INITS  *************/ 


#include "Packages.h"
#include "Sound.h"
#include "stdlib.h"
#include "stdio.h"
#include "files.h"

#define BASE_RES_ID			400
#define	GAME_WINDOW			401				
#define	DUNGEON_WINDOW		402				/* not used currently */


#define	OKAY_ITEM			1
#define	CANCEL_ITEM			2
#define	ROLLER_ITEM			5
#define	TEXT_ITEM			4
	
#define NIL_POINTER			0L
#define MOVE_TO_FRONT		(WindowPtr)-1L
#define REMOVE_ALL_EVENTS	0
#define ADD_CHECKMARK		TRUE
#define REMOVE_CHECKMARK	FALSE
#define DRAG_THRESHOLD		30

#define	SWORD				1
#define	DAGGER				2
#define	FLAIL				3
#define	GAUNTLETS			4
#define	CLOAK				5
#define	ARMOR				6
#define	SHIELD				7
#define	HELMET				8
#define	RING				9
#define	OTHER				10
#define	SPHERE				11
#define	BURNEDITEM			12
#define	MAGICVIAL			100

#define	NIL_STRING			"\p"
#define	IGNORED_STRING		NIL_STRING
#define	NIL_FILE_FILTER		NIL_POINTER
#define	NIL_DIALOG_HOOK		NIL_POINTER

#define MIN_SLEEP			0L
#define NIL_MOUSE_REGION	0L

#define WNE_TRAP_NUM		0x60
#define UNIMPL_TRAP_NUM		0x9F

#define NEW_ITEM			1			/* File Menu	*/
#define	OPEN_ITEM			2
#define	CLOSE_ITEM			3
#define SAVE_ITEM			4
#define QUIT_ITEM			6

#define ABOUT_ITEM			1			/* Apple Menu	*/
#define	ABOUT_HELP			2

#define UNDO_ITEM			1			/* Edit Menu	*/
#define	CUT_ITEM			2
#define	COPY_ITEM			3
#define PASTE_ITEM			4
#define CLEAR_ITEM			5
 
#define APPLE_MENU_ID		BASE_RES_ID
#define FILE_MENU_ID		BASE_RES_ID+1
#define	EDIT_MENU_ID		BASE_RES_ID+2

#define ABOUT_ALERT_ID		400
#define	ABOUT_HELP_ID		401
#define NO_ROLL_ID			403

WindowPtr	gPictureWindow, gGameWindow;
Boolean		gDone, gWNEImplemented;
EventRecord	gTheEvent;
MenuHandle	gAppleMenu,gEditMenu,gFileMenu,gOptionsMenu,gSpecialMenu;
PicHandle	gThePicture;
int			gSndOn=0,gPauseOn=1,gPanicOn=0, gInCastle, gPartyNum,gNewChar,
			gCurItem, gInPrison, gSndNum;
DialogPtr	gDialog;
RGBColor	gNameBack, gStatsBack;

struct	ItemInfo 
{
	Str255			name;
	unsigned char	type;
	unsigned char	status;		/* whether item is in use or not */
	unsigned char	instore;
	unsigned char	level;
	Byte			attrib;
	unsigned char	dmg;
	unsigned char	def;
	unsigned char	con;
};

struct	ItemInfo	GameItems[101];						

/********************************** main *****************************/

main()
{
	ToolBoxInit();
	MenuBarInit();
	VarInit();
	GetDateTime(&randSeed);				/* randomize using datetme */
	OpenGame();
	MainLoop();
}

/******************************* VarInit ************************/
VarInit()
{
int	z;



	for (z=0;z<=100;z++)
		GameItems[z].status=99;		/* all slots open */
		
	gCurItem = 0;


}
/******************************* ToolBoxInit ************************/

ToolBoxInit()
{
	InitGraf (&thePort);
	InitFonts();
	FlushEvents (everyEvent, REMOVE_ALL_EVENTS);
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs (NIL_POINTER);
	InitCursor();
}

/**************************** MenuBarInit *****************************/

MenuBarInit()
{
	Handle	myMenuBar;
	
	myMenuBar =   GetNewMBar(BASE_RES_ID);	  /* Menu Index */
	SetMenuBar(myMenuBar);
	gFileMenu  = GetMHandle(FILE_MENU_ID);
	gAppleMenu = GetMHandle(APPLE_MENU_ID);
	gEditMenu  = GetMHandle(EDIT_MENU_ID);
	AddResMenu(gAppleMenu, 'DRVR');
	DrawMenuBar();
}

/********************** HandleEvent ***********************************/

HandleEvent()
{
	char	theChar;
	GrafPtr	oldPort;
	Rect	myRect;
	
	if (gWNEImplemented)
		WaitNextEvent(everyEvent,&gTheEvent,MIN_SLEEP,NIL_MOUSE_REGION);
	else
	{
		SystemTask();
		GetNextEvent(everyEvent, &gTheEvent);
	}
	
	switch (gTheEvent.what)
	{
		case updateEvt:							/* need to update chars too! */
 			GetPort(&oldPort);		 
			SetPort((WindowPtr)gTheEvent.message);
			BeginUpdate((WindowPtr)gTheEvent.message);
			EndUpdate((WindowPtr)gTheEvent.message);
 			SetPort(oldPort); 
			break;
		case nullEvent:
			HandleNull();
			break;
		case mouseDown:
			HandleMouseDown();
			break;
		case keyDown:
		case autoKey:
			theChar = gTheEvent.message & charCodeMask;
			if ((gTheEvent.modifiers & cmdKey) != 0)
				HandleMenuChoice(MenuKey(theChar));
			break;
	}
}

/********************** HandleNull ***********************************/

HandleNull()
{
	
}

/********************** HandleMouseDown ******************************/

HandleMouseDown()
{
	WindowPtr	whichWindow;
	short int	thePart;
	long int	menuChoice, windSize;
	
	thePart= FindWindow(gTheEvent.where, &whichWindow);
	switch(thePart)
	{
		case inMenuBar:
			menuChoice = MenuSelect(gTheEvent.where);
			HandleMenuChoice(menuChoice);
			break;
		case inSysWindow:
			SystemClick(&gTheEvent, whichWindow);
			break;
		}
}

/********************** HandleMenuChoice *****************************/

HandleMenuChoice(menuChoice)
long int	menuChoice;

{
	int	theMenu;
	int	theItem;
	
	if (menuChoice!=0)
	{
		theMenu = HiWord(menuChoice);
		theItem = LoWord(menuChoice);
		switch (theMenu)
		{
			case APPLE_MENU_ID:
				HandleAppleChoice(theItem);
				break;
			case FILE_MENU_ID:
				HandleFileChoice(theItem);
				break;
		}
		HiliteMenu(0);
	}
}

/********************** HandleAppleChoice *****************************/

HandleAppleChoice(theItem)
int	theItem;

{
	Str255		accName;
	int			accNumber;
	short int	itemNumber;
	DialogPtr	AboutDialog;
	
	switch(theItem)
	{
		case ABOUT_ITEM:
			NoteAlert(ABOUT_ALERT_ID,NIL_POINTER);
			break;
		case ABOUT_HELP:
			NoteAlert(ABOUT_HELP_ID,NIL_POINTER);
			break;
		default:
			GetItem(gAppleMenu, theItem, accName);
			accNumber=OpenDeskAcc(accName);
			break;
	}
}

/********************** HandleFileChoice *****************************/

HandleFileChoice(theItem)
int	theItem;
{
Boolean	Stop_Now;

	switch(theItem)
	{
		case NEW_ITEM:
			break;
		case OPEN_ITEM:
			OpenGame();
			break;
		case SAVE_ITEM:
			SaveGame();
			break;
		case QUIT_ITEM:
			gDone=TRUE;
			break;
	
	}
}


/********************** Mainloop ***********************************/

MainLoop()
{
	gDone = FALSE;
	gWNEImplemented = (NGetTrapAddress(WNE_TRAP_NUM, ToolTrap)!=
					   NGetTrapAddress(UNIMPL_TRAP_NUM, ToolTrap));
	while(gDone==FALSE)
	{
		HandleEvent();
	}
}

/************************ MainDialog ****************************/

MainDialog()
{

int			itemType, z,x,itemHit, inPrison,  dialogDone = FALSE; 
Handle		itemHandle;
Rect		itemRect;
Str255		text;

if (GameItems[101].status != 99)
{
	NoteAlert(128,NIL_POINTER);		/* no slots open */
}
 	gDialog=GetNewDialog(405, NIL_POINTER, MOVE_TO_FRONT);		 
		ShowWindow(gDialog);
		SetPort(gDialog);
		
		ListItem();
		
	GetDItem(gDialog, 11, &itemType, &itemHandle, &itemRect);
	SelIText ( gDialog,11,0,32767 );	
	
	NumToString(gCurItem,text);
	GetDItem(gDialog, 9, &itemType, &itemHandle, &itemRect);			/* get name */
	SetIText(itemHandle, text);
	

	while (dialogDone == FALSE)
	{
		ModalDialog(NIL_POINTER, &itemHit);
			switch (itemHit)
			{
				case 1:			/* DONE ... exit program 				*/
					SaveDialog();
					dialogDone = TRUE;
					DisposeDialog(gDialog);			 
					break;
				case 2:			/* ADD ... add it to the database 		*/
					for (x=0;x<=101;x++)
					  if (GameItems[x].status==99)
					  	{
					  	gCurItem=x;
					  	break;
					  	}					NewItem();
					dialogDone = TRUE;
					DisposeDialog(gDialog);
					MainDialog();			 
					break;		 
				case 3:			/* SEARCH ... now go search for it		*/
					SearchItem();	
					break;
				case 5:			/* BACK ...backwards in database 	*/
					if (gCurItem-1<=0)
						gCurItem=0;
					else
						gCurItem--;
					ListItem();		 
					break;
				case 4:			/* FORWARD */
			    		gCurItem++;
						ListItem();
					break;	
				case 6:			/* MODIFY */
					NewItem();
					MainDialog();			 
					break;
				case 13:		/* sword */
 	  				TurnOffButton();									 
					GetDItem(gDialog, itemHit, &itemType, 
					&itemHandle, &itemRect);
					SetCtlValue (itemHandle,1);
					GameItems[gCurItem].type=SWORD;				 
					break;	
				case 14:		/* dagger */
 	  				TurnOffButton();									 
					GetDItem(gDialog, itemHit, &itemType, 
					&itemHandle, &itemRect);
					SetCtlValue (itemHandle,1);
					GameItems[gCurItem].type=DAGGER;				 
					break;
				case 15:		/* flail */
 	  				TurnOffButton();									 
					GetDItem(gDialog, itemHit, &itemType, 
					&itemHandle, &itemRect);
					SetCtlValue (itemHandle,1);
					GameItems[gCurItem].type=FLAIL;				 
					break;						
				case 16:		/* gauntlet */
 	  				TurnOffButton();									 
					GetDItem(gDialog, itemHit, &itemType, 
					&itemHandle, &itemRect);
					SetCtlValue (itemHandle,1);
					GameItems[gCurItem].type=GAUNTLETS;				 
					break;
				case 17:		/* cloak */
 	  				TurnOffButton();									 
					GetDItem(gDialog, itemHit, &itemType, 
					&itemHandle, &itemRect);
					SetCtlValue (itemHandle,1);
					GameItems[gCurItem].type=CLOAK;				 
					break;						
				case 18:		/* armor */
 	  				TurnOffButton();									 
					GetDItem(gDialog, itemHit, &itemType, 
					&itemHandle, &itemRect);
					SetCtlValue (itemHandle,1);
					GameItems[gCurItem].type=ARMOR;				 
					break;		
				case 19:		/* shield */
 	  				TurnOffButton();									 
					GetDItem(gDialog, itemHit, &itemType, 
					&itemHandle, &itemRect);
					SetCtlValue (itemHandle,1);
					GameItems[gCurItem].type=SHIELD;				 
					break;	
				case 20:		/* helmet */
 	  				TurnOffButton();									 
					GetDItem(gDialog, itemHit, &itemType, 
					&itemHandle, &itemRect);
					SetCtlValue (itemHandle,1);
					GameItems[gCurItem].type=HELMET;				 
					break;
				case 21:		/* ring */
 	  				TurnOffButton();									 
					GetDItem(gDialog, itemHit, &itemType, 
					&itemHandle, &itemRect);
					SetCtlValue (itemHandle,1);
					GameItems[gCurItem].type=RING;				 
					break;						
				case 22:		/* other */
 	  				TurnOffButton();									 
					GetDItem(gDialog, itemHit, &itemType, 
					&itemHandle, &itemRect);
					SetCtlValue (itemHandle,1);
					GameItems[gCurItem].type=OTHER;				 
					break;
				case 23:		/* Sphere */
 	  				TurnOffButton();									 
					GetDItem(gDialog, itemHit, &itemType, 
					&itemHandle, &itemRect);
					SetCtlValue (itemHandle,1);
					GameItems[gCurItem].type=SPHERE;				 
					break;						
				case 24:		/* magic vial */
 	  				TurnOffButton();									 
					GetDItem(gDialog, itemHit, &itemType, 
					&itemHandle, &itemRect);
					SetCtlValue (itemHandle,1);
					GameItems[gCurItem].type=MAGICVIAL;				 
					break;														
		}
	}
	
 }
 
/************************ TurnOffButton ****************************/	
TurnOffButton()
{
int				itemType;
Handle			itemHandle;
Rect			itemRect;	
ControlHandle	control;
int				z;
  
for (z=13;z<=24;z++)				
	{
		GetDItem(gDialog, z, &itemType, &itemHandle, &itemRect);
		SetCtlValue (itemHandle,0);
	}  
}

/************************ SearchItem ****************************/

SearchItem()
{

int			itemType, z,x,y,itemHit,  dialogDone = FALSE; 
Handle		itemHandle;
Rect		itemRect;
Str255		text;

TurnOffButton();
	for (z=0;z<=101;z++)					 
	{
		GetDItem(gDialog, 11, &itemType, &itemHandle, &itemRect);	/* get name */
			GetIText(itemHandle, text);
		if ( EqualString ( GameItems[z].name, text, FALSE, FALSE ) )
			gCurItem=z;					 
	}
	NumToString(gCurItem,text);
	GetDItem(gDialog, 9, &itemType, &itemHandle, &itemRect);			/* get name */
	SetIText(itemHandle, text);	

	GetDItem(gDialog, 11, &itemType, &itemHandle, &itemRect);			/* get name */
	SetIText(itemHandle, GameItems[gCurItem].name);	

	GetDItem(gDialog, 26, &itemType, &itemHandle, &itemRect);			/* get name */
	NumToString(GameItems[gCurItem].instore,text);
	SetIText(itemHandle, text);	

	GetDItem(gDialog, 28, &itemType, &itemHandle, &itemRect);			/* get name */
	NumToString(GameItems[gCurItem].level,text);
	SetIText(itemHandle, text);	

	GetDItem(gDialog, 30, &itemType, &itemHandle, &itemRect);			/* get name */
	NumToString(GameItems[gCurItem].attrib,text);
	SetIText(itemHandle, text);	

	GetDItem(gDialog, 32, &itemType, &itemHandle, &itemRect);			/* get name */
	NumToString(GameItems[gCurItem].dmg,text);
	SetIText(itemHandle, text);	

	GetDItem(gDialog, 34, &itemType, &itemHandle, &itemRect);			/* get name */
	NumToString(GameItems[gCurItem].def,text);
	SetIText(itemHandle, text);	

	GetDItem(gDialog, 36, &itemType, &itemHandle, &itemRect);			/* get name */
	NumToString(GameItems[gCurItem].con,text);
	SetIText(itemHandle, text);	

y=13;
	for (x=1;x<=12;x++)
		{
			if (GameItems[gCurItem].type == x)
			{
			GetDItem(gDialog, y, &itemType, &itemHandle, &itemRect);
			SetCtlValue (itemHandle,1);
			}
		  y++;
		}
} 
 /************************ NewItem ****************************/

NewItem()
{

int			itemType, z,x,itemHit, inPrison,  dialogDone = FALSE; 
Handle		itemHandle;
Rect		itemRect;
Str255		text;
long		number;

  	
  	GameItems[gCurItem].status=1;		/* good item */
	NumToString(gCurItem,text);		/* record # */
	GetDItem(gDialog, 9, &itemType, &itemHandle, &itemRect);			/* get name */
	SetIText(itemHandle, text);

	GetDItem(gDialog, 11, &itemType, &itemHandle, &itemRect);			/* get name */
	GetIText(itemHandle, GameItems[gCurItem].name);

	GetDItem(gDialog, 26, &itemType, &itemHandle, &itemRect);			/* get name */
	GetIText(itemHandle, text);											/* get type */
	StringToNum(text,&number);			 
	GameItems[gCurItem].instore=number;
		
	GetDItem(gDialog, 28, &itemType, &itemHandle, &itemRect);			/* get name */
	GetIText(itemHandle, text);											/* get type */
	StringToNum(text,&number);			 
	GameItems[gCurItem].level=number;
	
	GetDItem(gDialog, 30, &itemType, &itemHandle, &itemRect);			/* get name */
	GetIText(itemHandle, text);											/* get type */
	StringToNum(text,&number);			 
	GameItems[gCurItem].attrib=number;
	
	GetDItem(gDialog, 32, &itemType, &itemHandle, &itemRect);			/* get name */
	GetIText(itemHandle, text);											/* get type */
	StringToNum(text,&number);			 
	GameItems[gCurItem].dmg=number;
	
	GetDItem(gDialog, 34, &itemType, &itemHandle, &itemRect);			/* get DEF */
	GetIText(itemHandle, text);											/* get type */
	StringToNum(text,&number);			 
	GameItems[gCurItem].def=number;
	
	GetDItem(gDialog, 36, &itemType, &itemHandle, &itemRect);			/* get name */
	GetIText(itemHandle, text);											/* get type */
	StringToNum(text,&number);			 
	GameItems[gCurItem].con=number;
	
}

/************************ OpenGame *************************************/
OpenGame()
{

	SFReply		reply;
	Point		myPoint;
	SFTypeList	typeList;
	int			numTypes;
	int			z;
	long		count;
	short		rc,fRefNum;	
	
	myPoint.h	=101;
	myPoint.v	= 101;
	typeList[0] = 'RJB1';
	numTypes	= 1;

		
	FSOpen("\pGBItems",0,&fRefNum);	
		count = (sizeof(struct ItemInfo)*101);
	 	FSRead ( fRefNum, &count, ((Ptr)GameItems));
		FSClose (fRefNum);
		fRefNum=0;			/* set to invalid # to avoid disk wipe-outs! */

MainDialog();
}


/************************ SaveGame *************************************/
SaveGame()
{
SFReply		reply;
Point		myPoint;
short		rc,fRefNum;
int			z;
long		count;
FInfo		fndrInfo;
OSType		fdType;

myPoint.h	=101;
myPoint.v	= 101;

 
	Create ("\pGBItems", 0, 'RJGB', 'RJG1');
	if (reply.good)
	{	
		FSOpen("\pGBItems",0,&fRefNum);
	}	
	/* now write data to file */


	FSOpen("\pGBItems",0,&fRefNum);
		count = (sizeof(struct ItemInfo)*101);
	 	FSWrite ( fRefNum,&count, ((Ptr)GameItems)); 		
		fndrInfo.fdType='RJG1';		/* set file creator type */
		fndrInfo.fdCreator='RJGB';		
		SetFInfo ("\pGBItems",0, &fndrInfo );
		FSClose (fRefNum);
	fRefNum=0;				 	/* set to invalid # to avoid disk wipe-outs! */
			
}
/************************ ListItem ****************************/

ListItem()
{

int			itemType, z,x,y,itemHit, inPrison,  dialogDone = FALSE; 
Handle		itemHandle;
Rect		itemRect;
Str255		text;

TurnOffButton();
	
	NumToString(gCurItem,text);
	GetDItem(gDialog, 9, &itemType, &itemHandle, &itemRect);			/* get name */
	SetIText(itemHandle, text);

	GetDItem(gDialog, 11, &itemType, &itemHandle, &itemRect);			/* get name */
	SetIText(itemHandle, GameItems[gCurItem].name);	

	GetDItem(gDialog, 26, &itemType, &itemHandle, &itemRect);			/* get name */
	NumToString(GameItems[gCurItem].instore,text);
	SetIText(itemHandle, text);	

	GetDItem(gDialog, 28, &itemType, &itemHandle, &itemRect);			/* get name */
	NumToString(GameItems[gCurItem].level,text);
	SetIText(itemHandle, text);	

	GetDItem(gDialog, 30, &itemType, &itemHandle, &itemRect);			/* get name */
	NumToString(GameItems[gCurItem].attrib,text);
	SetIText(itemHandle, text);	

	GetDItem(gDialog, 32, &itemType, &itemHandle, &itemRect);			/* get name */
	NumToString(GameItems[gCurItem].dmg,text);
	SetIText(itemHandle, text);	

	GetDItem(gDialog, 34, &itemType, &itemHandle, &itemRect);			/* get name */
	NumToString(GameItems[gCurItem].def,text);
	SetIText(itemHandle, text);	

	GetDItem(gDialog, 36, &itemType, &itemHandle, &itemRect);			/* get name */
	NumToString(GameItems[gCurItem].con,text);
	SetIText(itemHandle, text);	

y=13;
	for (x=1;x<=12;x++)
		{
			if (GameItems[gCurItem].type == x)
			{
			GetDItem(gDialog, y, &itemType, &itemHandle, &itemRect);
			SetCtlValue (itemHandle,1);
			}
		  y++;
		}
} 
/************************ SaveDialog ****************************/

SaveDialog()
{

int			itemType, z,x,itemHit, inPrison,  dialogDone = FALSE; 
Handle		itemHandle;
Rect		itemRect;
Str255		text;


 	gDialog=GetNewDialog(128, NIL_POINTER, MOVE_TO_FRONT);		 
		ShowWindow(gDialog);
		SetPort(gDialog);

			GetDItem(gDialog, 1, &itemType, &itemHandle, &itemRect);
			PenSize(2,2);	
			InsetRect(&itemRect, -3,-3);
			FrameRoundRect(&itemRect, 16, 16);
			PenNormal();
			
	while (dialogDone == FALSE)
	{
		ModalDialog(NIL_POINTER, &itemHit);
			switch (itemHit)
			{
				case 1:			/* YES ... & exit program 		*/
					SaveGame();
					dialogDone = TRUE;
					DisposeDialog(gDialog);
					ExitToShell();			 
					break;
				case 2:			/* NO ... exit, no save 		*/
					NewItem();
					dialogDone = TRUE;
					DisposeDialog(gDialog);
					ExitToShell(); 
					break;		 
				case 3:			/* CANCEL ... no go search for it		*/
					MainDialog();	
					break;
			}
	}
}